@extends('layouts.PDF.app')
@section('certificado')
    <p class="text-left subtitulo">11 de febrero de 2025<br>
        Laboratorio Clínico XXXX<br>
        Control de Calidad de Microbiología<br>
        Control de calidad de Medios de cultivo</p>
@endsection
@section('titulo')
    <h1 class="text-center">CONTROL DE CALIDAD DE MEDIOS DE CULTIVO</h1>
@endsection
@section('content')
    <div class="info-section">
        <h2 class="text-center">Medio de cultivo</h2>
        <table class="tabla-principal">

            <tr>
                <td><strong>Fecha informe</strong></td>
                <td>{{ $fechaActual }}</td>
                <td><strong>Medio de cultivo</strong></td>
                <td>{{ $nombreMedio }}</td>
            </tr>
            <tr>
                <td><strong>Lote</strong></td>
                <td>{{ $loteMedio }}</td>
                <td><strong>Fecha de expiración</strong></td>
                <td>{{ $VencimientoLoteMedio }}</td>
            </tr>
        </table>
    </div>
    <!-- Información de Cepas -->
    <div class="cepas-section">
        <h2 class="text-center">Microorganismos de control</h2>
        <table class="tabla-principal">
            <thead>
                <tr>
                    <td class="text-center"><strong>Cepa</strong></td>
                    <td class="text-center"><strong>Lote</strong></td>
                    <td class="text-center"><strong>F. vencimiento</strong></td>
                </tr>
            </thead>
            @if (is_null($CepasDeLote) || count($CepasDeLote) == 0)
                <tr>
                    <td colspan="3" class="text-center">No se han registrado cepas</td>
                </tr>
            @else
                @foreach ($CepasDeLote as $key => $cepas)
                    <tr>
                        <td class="text-center"><i>{{ $cepas->loteCepas->cepas->first()->nom_cepa }}</i></td>
                        <td class="text-center">{{ $cepas->loteCepas->lote }}</td>
                        <td class="text-center">{{ $cepas->loteCepas->fecha_vencimiento }}</td>
                    </tr>
                @endforeach
            @endif

        </table>
    </div>
    <div class="controles-section">
        <table class="tabla-principal">
            <thead>
                <tr>
                    @foreach ($ControlesCepa as $ke1 => $cepas)
                        <th><i>{{ $cepas->loteCepas->cepas->first()->nom_cepa }}</i></th>
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @for ($i = 0; $i < $maxRegistros; $i++)
                    <tr>
                        @foreach ($ControlesCepa as $cepas)
                            <td>
                                @if (isset($cepas->comentariosLoteCepa[$i]))
                                    <div>
                                        @if ($cepas->comentariosLoteCepa[$i]->url())
                                            <img src="{{ $cepas->comentariosLoteCepa[$i]->url() }}"
                                                alt="Imagen no disponible" class="imagen-control">
                                        @else
                                            <p class="sin-imagen">No se ha súbido imagen</p>
                                        @endif
                                        <div class="contenido-texto">
                                            <p>
                                                <small class="text-center"><i>Fecha de registro
                                                        {{ $cepas->comentariosLoteCepa[$i]->created_at->toDateString() }}</i></small><br>
                                                <strong>Usuario:</strong> {{ Auth::user()->nom_usuario ?? 'SW' }}<br>
                                                <strong>Resultado:</strong>
                                                {{ $cepas->comentariosLoteCepa[$i]->tipoMedicion->nombre }}<br>
                                                <strong>Comentario:</strong>
                                                {{ $cepas->comentariosLoteCepa[$i]->comentario }}

                                            </p>
                                        </div>
                                    </div>
                                @endif
                            </td>
                        @endforeach
                    </tr>
                @endfor
            </tbody>
        </table>
    </div>
@endsection
