<?php $__env->startSection('certificado'); ?>
    <p class="text-left subtitulo">11 de febrero de 2025<br>
        Laboratorio Clínico XXXX<br>
        Control de Calidad de Microbiología<br>
        Control de calidad de Medios de cultivo</p>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('titulo'); ?>
    <h1 class="text-center">CONTROL DE CALIDAD DE MEDIOS DE CULTIVO</h1>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="info-section">
        <h2 class="text-center">Medio de cultivo</h2>
        <table class="tabla-principal">

            <tr>
                <td><strong>Fecha informe</strong></td>
                <td><?php echo e($fechaActual); ?></td>
                <td><strong>Medio de cultivo</strong></td>
                <td><?php echo e($nombreMedio); ?></td>
            </tr>
            <tr>
                <td><strong>Lote</strong></td>
                <td><?php echo e($loteMedio); ?></td>
                <td><strong>Fecha de expiración</strong></td>
                <td><?php echo e($VencimientoLoteMedio); ?></td>
            </tr>
        </table>
    </div>
    <!-- Información de Cepas -->
    <div class="cepas-section">
        <h2 class="text-center">Microorganismos de control</h2>
        <table class="tabla-principal">
            <thead>
                <tr>
                    <td class="text-center"><strong>Cepa</strong></td>
                    <td class="text-center"><strong>Lote</strong></td>
                    <td class="text-center"><strong>F. vencimiento</strong></td>
                </tr>
            </thead>
            <?php if(is_null($CepasDeLote) || count($CepasDeLote) == 0): ?>
                <tr>
                    <td colspan="3" class="text-center">No se han registrado cepas</td>
                </tr>
            <?php else: ?>
                <?php $__currentLoopData = $CepasDeLote; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $cepas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-center"><i><?php echo e($cepas->loteCepas->cepas->first()->nom_cepa); ?></i></td>
                        <td class="text-center"><?php echo e($cepas->loteCepas->lote); ?></td>
                        <td class="text-center"><?php echo e($cepas->loteCepas->fecha_vencimiento); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

        </table>
    </div>
    <div class="controles-section">
        <table class="tabla-principal">
            <thead>
                <tr>
                    <?php $__currentLoopData = $ControlesCepa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ke1 => $cepas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th><i><?php echo e($cepas->loteCepas->cepas->first()->nom_cepa); ?></i></th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            </thead>
            <tbody>
                <?php for($i = 0; $i < $maxRegistros; $i++): ?>
                    <tr>
                        <?php $__currentLoopData = $ControlesCepa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cepas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <?php if(isset($cepas->comentariosLoteCepa[$i])): ?>
                                    <div>
                                        <?php if($cepas->comentariosLoteCepa[$i]->url()): ?>
                                            <img src="<?php echo e($cepas->comentariosLoteCepa[$i]->url()); ?>"
                                                alt="Imagen no disponible" class="imagen-control">
                                        <?php else: ?>
                                            <p class="sin-imagen">No se ha súbido imagen</p>
                                        <?php endif; ?>
                                        <div class="contenido-texto">
                                            <p>
                                                <small class="text-center"><i>Fecha de registro
                                                        <?php echo e($cepas->comentariosLoteCepa[$i]->created_at->toDateString()); ?></i></small><br>
                                                <strong>Usuario:</strong> <?php echo e(Auth::user()->nom_usuario ?? 'SW'); ?><br>
                                                <strong>Resultado:</strong>
                                                <?php echo e($cepas->comentariosLoteCepa[$i]->tipoMedicion->nombre); ?><br>
                                                <strong>Comentario:</strong>
                                                <?php echo e($cepas->comentariosLoteCepa[$i]->comentario); ?>


                                            </p>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                <?php endfor; ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.PDF.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wtredataphp\apitool-test3.quik-apps.com.co\resources\views/microbiologia/mediosDeCultivos/PDF/informeControlCepa.blade.php ENDPATH**/ ?>