@extends('layouts.app-v2')
@section('content-section')
    <div class="py-3 px-2">
        <div class="col-sm-12 col-md-12 ">
            <div class="row note note-light note-contraste">
                <div class="col-md-9">
                    <ul id='informacion_cepa' style="list-style: none;">
                        <li><strong>Laboratorio:</strong><span class='laboratorio'>{{ $data->nom_laboratorio }} <!--- <small>Id
                                    laboratorio: {{ $data->id_laboratorio }}</small>---></span></li>
                        <li><strong>Medio de cultivo:</strong> <span
                                class='medio'>{{ $medio->lote->medios->first()->nom_medio }}</span></li>
                        <li><strong>Lote Medio Cultivo:</strong> <span class='lote'>{{ $medio->lote->lote }}</span>
                            <!---<small>Id lote: {{ $medio->lote->id }}</small>--->
                        </li>
                        <li><strong>Fecha Vencimiento Lote Medio: </strong><span
                                class='lote'>{{ is_null($medio->lote) ? 'Sin Fecha de vencimiento' : $medio->lote->fecha_vencimiento }}</span>
                        </li>
                        @if (!is_null($medio->lote->LoteMedioCepas))
                            @foreach ($medio->lote->LoteMedioCepas()->where('lote_laboratorio_id', $data->id_laboratorio)->get() as $key => $cepas)
                                <li><strong>Cepa {{ $key + 1 }}</strong>
                                    {{ $cepas->loteCepas->cepas->first()->nom_cepa }} | <strong>Lote</strong>
                                    {{ $cepas->loteCepas->lote }} {{ $cepas->loteCepas->id }} | <strong>Fecha de
                                        vencimiento</strong> {{ $cepas->loteCepas->fecha_vencimiento }}</li>
                            @endforeach
                        @endif
                    </ul>
                </div>
                <div class="col-md-3">
                    <a href="{{ route('generar.informe.pdf', ['loteId' => $medio->lote_id, 'section' => 'Medio']) }}"
                        target="_blank" class="btn btn-primary btn-block" data-toggle="tooltip" data-placement="top"
                        title="Descargar informe de medio de cultivo">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="15" height="15"
                            stroke="currentColor" fill="#ffffff">
                            <path
                                d="M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 144-208 0c-35.3 0-64 28.7-64 64l0 144-48 0c-35.3 0-64-28.7-64-64L0 64zm384 64l-128 0L256 0 384 128zM176 352l32 0c30.9 0 56 25.1 56 56s-25.1 56-56 56l-16 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48 0-80c0-8.8 7.2-16 16-16zm32 80c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0 0 48 16 0zm96-80l32 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-32 0c-8.8 0-16-7.2-16-16l0-128c0-8.8 7.2-16 16-16zm32 128c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-16 0 0 96 16 0zm80-112c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64 0-64z" />
                        </svg>
                        Descargar pdf
                    </a>
                    <form action="{{ route('microbiologia.medio.laboratorio.eliminar', ['id' => $medio->id]) }}"
                        class="form-eliminar" method="post">
                        @csrf
                        @method('delete')
                        <input type="hidden" name="laboratorioId" value="{{ $data->id_laboratorio }}">
                        <button type="submit" class="btn btn-danger btn-block" data-toggle="tooltip" data-placement="top"
                            title="Eliminar medio de cultivo del laboratorio">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-trash align-middle mr-2">
                                <polyline points="3 6 5 6 21 6">
                                </polyline>
                                <path d="M19 6l-1.23 13.73A2 2 0 0 1 15.78 22H8.22a2 2 0 0 1-1.99-2.27L5 6">
                                </path>
                                <path d="M10 11v6"></path>
                                <path d="M14 11v6"></path>
                            </svg> Eliminar</button>
                    </form>
                </div>
            </div>
        </div>

        @if ($medio->lote->LoteMedioCepas()->where('lote_laboratorio_id', $data->id_laboratorio)->count() < 2)
            <div class="py-3 px-2">
                <form action="{{ route('asignar.loteCepa.loteMedio') }}" method="POST">
                    @csrf
                    <div class="col-md-12 col-12 mt-3">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <div class="row align-items-end">
                                    @php
                                        $id = null;
                                        /**  if ($medio->lote->LoteMedioCepas()->where('lote_laboratorio_id', $data->id_laboratorio)->first()) {
                                            $id = $medio->lote->LoteMedioCepas()->first()->lote_cepa_id;
                                        }**/
                                    @endphp
                                    <div class="col-12 col-sm-4 mb-2 mb-sm-0">

                                        <select name="loteCepaId" id="loteCepaId" class="form-select w-100"
                                            style="height: 6vh;">
                                            @foreach ($lotesCepa as $lote)
                                                @if ($id !== $lote->id)
                                                    @foreach ($lote->cepas as $cepa)
                                                        <option value="{{ $lote->id }}">Lote: {{ $lote->lote }} |
                                                            Cepa: {{ $cepa->nom_cepa }}</option>
                                                    @endforeach
                                                @endif
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-12 col-sm-4">
                                        <input type="hidden" name="loteMedioId" value="{{ $medio->lote->id }}">
                                        <input type="hidden" name="laboratorioId" value="{{ $data->id_laboratorio }}">
                                        <button type="submit" class="btn btn-primary w-100" data-toggle="tooltip"
                                            data-placement="top" title="Agregar cepa a medio de cultivo">Agregar</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        @endif
        <div class="row py-3 px-2">
            @if ($medio->lote->LoteMedioCepas()->where('lote_laboratorio_id', $data->id_laboratorio)->count() > 0)
                @foreach ($medio->lote->LoteMedioCepas()->where('lote_laboratorio_id', $data->id_laboratorio)->get() as $ke1 => $cepas)
                    <div class="col-md">
                        <form action="{{ route('registro.cepa.medio') }}" enctype="multipart/form-data" method="POST"
                            class="row" style="background-color: #f3f3f3 !important;">
                            <table class="table table-bordered table-sm" style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th colspan="7">
                                            <div class="d-flex justify-content-center align-items-center">
                                                <strong>{{ $cepas->loteCepas->cepas->first()->nom_cepa }} - <small> Id lote
                                                        {{ $cepas->loteCepas->id }}</small> </strong>
                                            </div>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th scope='col' style="width: 300px;">Comentario</th>
                                        <th scope='col'>Medición</th>
                                        <th scope='col'>Imagen</th>
                                        <th scope='col' colspan="2" id="col-accion">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            @csrf
                                            <input type="hidden" name="seguimientoPrueba" value="{{ $cepas->id }}">
                                            <input type="hidden" name="laboratorioId" value="{{ $data->id_laboratorio }}">
                                            <textarea required name="comentario" id="comentario_0"class="form-control" style="width: 100%;"
                                                placeholder="Escribe un comentario"></textarea>
                                            <small><strong>Usuario:</strong> {{ Auth::user()->iniciales ?? 'SW' }}</small>
                                            | <small><strong>Fecha: </strong>{{ $hoy->isoFormat('M/D/YY HH:mm') }}</small>
                                        </td>
                                        <td>
                                            <select name="tipoMedicionId" id="select-reg-control-0" class="form-select"
                                                style="width: 100%;" required>
                                                @foreach ($tiposMedicion as $tipo)
                                                    <option value="{{ $tipo->id }}">{{ $tipo->nombre }}</option>
                                                @endforeach
                                            </select>
                                        </td>
                                        <td>
                                            <div class="custom-file-upload">
                                                <input type="file" name="foto_url"
                                                    id="foto_url{{ $cepas->loteCepas->id }}{{ $ke1 }}"
                                                    accept="image/png, image/jpeg" value="" hidden />
                                                <label for="foto_url{{ $cepas->loteCepas->id }}{{ $ke1 }}">
                                                    <!-- https://feathericons.dev/?search=image&iconset=feather -->
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                        width="24" height="24" class="main-grid-item-icon"
                                                        fill="none" stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" stroke-width="2">
                                                        <rect height="18" rx="2" ry="2"
                                                            width="18" x="3" y="3" />
                                                        <circle cx="8.5" cy="8.5" r="1.5" />
                                                        <polyline points="21 15 16 10 5 21" />
                                                    </svg>

                                                </label>
                                            </div>
                                        </td>
                                        <td colspan="2">
                                            <input type="submit" class="btn btn-primary" value="Agregar"
                                                data-toggle="tooltip" data-placement="top"
                                                title="Agregar comentario cepa">
                                        </td>
                                    </tr>
                                </tbody>

                            </table>
                        </form>

                        <table class="table table-bordered table-sm" style="width: 100%;">
                            <tbody>
                                @foreach ($cepas->comentariosLoteCepa()->where('lote_laboratorio_id', $data->id_laboratorio)->get() as $cepa)
                                    <tr>
                                        <form action="{{ route('update.cepa.control', ['id' => $cepa->id]) }}"
                                            enctype="multipart/form-data" method="POST">
                                            <td>
                                                @csrf
                                                @method('PUT')
                                                <textarea name="comentario" id="comentario" class="form-control" style="width: 100%;">{{ $cepa->comentario }}</textarea>
                                                <small><strong>Usuario:</strong> {{ $cepa->usuario->iniciales }}</small> |
                                                <small><strong>Fecha:
                                                    </strong>{{ $cepa->created_at->isoFormat('M/D/YY HH:mm') }}</small>
                                            </td>
                                            <td>
                                                <select name="tipoMedicionId" id="select-reg-control" class="form-select"
                                                    style="width: 100%;">
                                                    <option value=""></option>
                                                    @foreach ($tiposMedicion as $tipo)
                                                        <option value="{{ $tipo->id }}"
                                                            {{ $cepa->medicion_id == $tipo->id ? 'selected' : '' }}>
                                                            {{ $tipo->nombre }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </td>
                                            <td>

                                                <input type="hidden" name="fotoOld" value="{{ $cepa->foto_url }}">
                                                <div class="custom-file-upload">
                                                    <input type="file" name="foto_url"
                                                        id="foto_url{{ $cepa->foto_url }}" accept="image/png, image/jpeg"
                                                        hidden />
                                                    <label for="foto_url{{ $cepa->foto_url }}">
                                                        <!-- https://feathericons.dev/?search=image&iconset=feather -->
                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                            width="24" height="24" class="main-grid-item-icon"
                                                            fill="none" stroke="currentColor" stroke-linecap="round"
                                                            stroke-linejoin="round" stroke-width="2">
                                                            <rect height="18" rx="2" ry="2"
                                                                width="18" x="3" y="3" />
                                                            <circle cx="8.5" cy="8.5" r="1.5" />
                                                            <polyline points="21 15 16 10 5 21" />
                                                        </svg>

                                                    </label>
                                                </div>
                                                @if ($cepa->foto_url)
                                                    <a href="{{ asset('storage/' . $cepa->foto_url) }}"
                                                        class="text-center" style="text-align: center;"
                                                        target="_blank">Ver
                                                        Imagen</a>
                                                @endif
                                            </td>
                                            <td>
                                                <input type="hidden" name="seguimientoPrueba"
                                                    value="{{ $cepas->id }}">
                                                <button type="submit" class="btn-primary" id="btn-accion"
                                                    data-toggle="tooltip" data-placement="top"
                                                    title="Actualizar comentario cepa">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                        viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                        class="feather feather-edit align-middle mr-2">
                                                        <path d="M11 21H4a2 2 0 0 1-2-2v-7a2 2 0 0 1 2-2h7">
                                                        </path>
                                                        <path
                                                            d="M18.5 2.5l3 3a2.121 2.121 0 0 1 0 3L12 18 7 20 9 15 18.5 2.5z">
                                                        </path>
                                                    </svg>
                                                </button>
                                            </td>
                                        </form>
                                        <td>
                                            <form action="{{ route('destroy.comentario.medio', ['id' => $cepa->id]) }}"
                                                class="form-eliminar" method="POST">
                                                @csrf
                                                @method('delete')
                                                <button class="btn-danger" id="btn-accion" data-toggle="tooltip"
                                                    data-placement="top" title="Eliminar comentario">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                        viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                        class="feather feather-trash align-middle mr-2">
                                                        <polyline points="3 6 5 6 21 6">
                                                        </polyline>
                                                        <path
                                                            d="M19 6l-1.23 13.73A2 2 0 0 1 15.78 22H8.22a2 2 0 0 1-1.99-2.27L5 6">
                                                        </path>
                                                        <path d="M10 11v6"></path>
                                                        <path d="M14 11v6"></path>
                                                    </svg>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <br>
                        <form action="{{ route('destroy.control.cepa.medio', ['id' => $cepas->loteCepas->id]) }}"
                            class="form-eliminar" method="post">
                            @csrf
                            @method('delete')
                            <input type="hidden" name="loteMedioId" value="{{ $medio->lote->id }}">
                            <input type="hidden" name="laboratorioId" value="{{ $data->id_laboratorio }}">
                            <button type="submit" class="btn btn-danger" data-toggle="tooltip" data-placement="top"
                                title="Eliminar cepa">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round"
                                    class="feather feather-trash align-middle mr-2">
                                    <polyline points="3 6 5 6 21 6">
                                    </polyline>
                                    <path d="M19 6l-1.23 13.73A2 2 0 0 1 15.78 22H8.22a2 2 0 0 1-1.99-2.27L5 6">
                                    </path>
                                    <path d="M10 11v6"></path>
                                    <path d="M14 11v6"></path>
                                </svg>
                                Eliminar cepa
                            </button>
                        </form>
                    </div>
                @endforeach
            @else
                <div class="col-md-12 col-12 mt-3 text-center">
                    <h3>No tiene cepas relacionadas</h3>
                </div>
            @endif
        </div>
    </div>
@endsection
