<?php
namespace App\Resource\Cepa;


use App\CompraLote;
use App\SeguimientoCepaPruebaSensibilidad;
use App\ControlCepaPruebaSensibilidad;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use App\Resource\Archivos\Subir;
use App\SeguimientoCepaTincion;
use App\ControlCepaTincion;
use App\ControlCepaMedio;
use App\Cepa;
use App\SeguimientoCepaMedio;
use Exception;

class Manager
{

    const CARPETA = 'CONTROL_CEPA/FOTO';

    public function findRegistroControlCepaMedio($id)
    {
        return ControlCepaMedio::select('id', 'comentario', 'foto_url', 'medicion_id', 'id_usuario')->find($id);
    }

    public function findRegistroControlCepaTincion($id)
    {
        return ControlCepaTincion::select('id', 'comentario', 'foto_url', 'medicion_id', 'usuario_id')->find($id);
    }

    public function findRegistroControlCepaPrueba($id)
    {
        return ControlCepaPruebaSensibilidad::select('id', 'comentario', 'foto_url', 'medicion_id', 'usuario_id')->find($id);
    }

    public static function findCepaById($id)
    {
        return Cepa::select('id_cepa', 'nom_cepa', 'num_lote', 'fecha', 'cualitativo', 'estado')->find($id);
    }

    public static function listarControlesCepaByLote($loteLabId)
    {
        return ControlCepaMedio::where('lote_laboratorio_id', $loteLabId)->select('id', 'comentario', 'foto_url', 'medicion_id', 'id_usuario', 'prueba_lote_id', 'created_at')->with('pruebaLote.loteCepa.cepas')->get();
    }

    public function asignarLoteCepa($request)
    {
        return SeguimientoCepaMedio::create([
            'lote_cepa_id' => $request->loteCepaId,
            'lote_medio_id' => $request->loteMedioId,
            'lote_laboratorio_id' => $request->laboratorioId
        ]);
    }
    public function asignarLoteCepaTincion($request)
    {
        return SeguimientoCepaTincion::create([
            'lote_cepa_id' => $request->loteCepaId,
            'lote_tincion_id' => $request->loteTincionId,
            'lote_laboratorio_id' => $request->laboratorioId
        ]);

    }
    public function asignarLoteCepaPrueba($request)
    {
        return SeguimientoCepaPruebaSensibilidad::create([
            'lote_cepa_id' => $request->loteCepaId,
            'lote_prueba_id' => $request->lotePruebaId,
            'lote_laboratorio_id' => $request->laboratorioId
        ]);

    }

    public function registrarControlCepaMedio($request)
    {
        DB::beginTransaction();
        $path = null;

        if (isset($request->foto_url) && !is_null($request->foto_url)) {
            $archivo = new Subir($request->foto_url, self::CARPETA);
            $archivo->guardar();
            $path = $archivo->getPath();
        }

        ControlCepaMedio::create([
            'comentario' => $request->comentario,
            'foto_url' => $path,
            'medicion_id' => $request->tipoMedicionId,
            'id_usuario' => Auth::user()->id_usuario,
            'seguimiento_cepa_id' => $request->seguimientoPrueba,
            "lote_laboratorio_id" => $request->laboratorioId
        ]);

        DB::commit();
        return true;
    }

    public function registrarControlTincion($request)
    {
        try {
            DB::beginTransaction();

            $path = null;

            if (isset($request->foto_url) && !is_null($request->foto_url)) {
                $archivo = new Subir($request->foto_url, self::CARPETA);
                $archivo->guardar();
                $path = $archivo->getPath();
            }

            ControlCepaTincion::create([
                'comentario' => $request->comentario,
                'foto_url' => $path,
                'medicion_id' => $request->tipoMedicionId,
                'usuario_id' => Auth::user()->id_usuario,
                'seguimiento_cepa_id' => $request->seguimientoPrueba,
                'lote_laboratorio_id' => $request->laboratorioId
            ]);
            DB::commit();
            return true;
        } catch (Exception $e) {
            Log::error('Error ocurrido al crear el registro de control de la cepa de la tincion: ' . $e->getMessage());
            throw new Exception('Error ocurrido al crear el registro de control de la cepa de la tincion');
        }

    }
    public function registrarControlPrueba($request)
    {
        $path = null;

        if (isset($request->foto_url) && !is_null($request->foto_url)) {
            $archivo = new Subir($request->foto_url, self::CARPETA);
            $archivo->guardar();
            $path = $archivo->getPath();
        }

        return ControlCepaPruebaSensibilidad::create([
            'comentario' => $request->comentario,
            'foto_url' => $path,
            'medicion_id' => $request->tipoMedicionId,
            'usuario_id' => Auth::user()->id_usuario,
            'seguimiento_cepa_id' => $request->seguimientoPrueba,
            'lote_laboratorio_id' => $request->laboratorioId
        ]);
    }
    public function updateControlMedio($request, $id)
    {
        try {
            DB::beginTransaction();
            $controlCepa = $this->findRegistroControlCepaMedio($id);
            $path = null;
            if (isset($request->foto_url) && !is_null($request->foto_url)) {
                Log::info('se sube una foto para guardar');
                $archivo = new Subir($request->foto_url, self::CARPETA);
                $archivo->guardar();
                $path = $archivo->getPath();
                if (isset($request->fotoOld) && !is_null($request->fotoOld)) {
                    Log::info('viene foto vieja para eliminar');
                    $archivo->eliminarArchivo($request->fotoOld);
                }
                $controlCepa->update(['foto_url' => $path]);
            }
            $controlCepa->update([
                'comentario' => $request->comentario,
                'medicion_id' => $request->tipoMedicionId,
                'id_usuario' => Auth::user()->id_usuario,
                'seguimiento_cepa_id' => $request->seguimientoPrueba
            ]);
            DB::commit();
        } catch (Exception $e) {
            DB::rollBack();
            Log::error('Error: no fue posible actualizar el control de la cepa.' . $e->getMessage());
            throw new Exception('Error: no fue posible actualizar el control de la cepa');
        }
    }

    public function updateControlTincion($request, $id)
    {
        try {
            DB::beginTransaction();
            $controlCepa = $this->findRegistroControlCepaTincion($id);
            $path = null;
            if (isset($request->foto_url) && !is_null($request->foto_url)) {
                Log::info('se sube una foto para guardar');
                $archivo = new Subir($request->foto_url, self::CARPETA);
                $archivo->guardar();
                $path = $archivo->getPath();
                if (isset($request->fotoOld) && !is_null($request->fotoOld)) {
                    Log::info('viene foto vieja para eliminar');
                    $archivo->eliminarArchivo($request->fotoOld);
                }
                $controlCepa->update(['foto_url' => $path]);
            }
            $controlCepa->update([
                'comentario' => $request->comentario,
                'medicion_id' => $request->tipoMedicionId,
                'usuario_id' => Auth::user()->id_usuario,
                'seguimiento_cepa_id' => $request->seguimientoPrueba
            ]);
            DB::commit();
        } catch (Exception $e) {
            DB::rollBack();
            Log::error('Error: no fue posible actualizar el control de la cepa.' . $e->getMessage());
            throw new Exception('Error: no fue posible actualizar el control de la cepa');
        }
    }

    public function updateControlPrueba($request, $id)
    {
        try {
            DB::beginTransaction();
            $controlCepa = $this->findRegistroControlCepaPrueba($id);
            $path = null;
            if (isset($request->foto_url) && !is_null($request->foto_url)) {
                Log::info('se sube una foto para guardar');
                $archivo = new Subir($request->foto_url, self::CARPETA);
                $archivo->guardar();
                $path = $archivo->getPath();
                if (isset($request->fotoOld) && !is_null($request->fotoOld)) {
                    Log::info('viene foto vieja para eliminar');
                    $archivo->eliminarArchivo($request->fotoOld);
                }
                $controlCepa->update(['foto_url' => $path]);
            }
            $controlCepa->update([
                'comentario' => $request->comentario,
                'medicion_id' => $request->tipoMedicionId,
                'usuario_id' => Auth::user()->id_usuario,
                'seguimiento_cepa_id' => $request->seguimientoPrueba
            ]);
            DB::commit();
        } catch (Exception $e) {
            DB::rollBack();
            Log::error('Error: no fue posible actualizar el control de la cepa.' . $e->getMessage());
            throw new Exception('Error: no fue posible actualizar el control de la cepa');
        }
    }

    public function destroyComentarioMedio($id)
    {
        $controlmedio = ControlCepaMedio::find($id);
        return $controlmedio->delete();
    }
    public function destroyComentarioTincion($id)
    {
        $controltinsion = ControlCepaTincion::find($id);
        return $controltinsion->delete();
    }

    public function destroyComentarioPrueba($id)
    {
        $controltinsion = ControlCepaPruebaSensibilidad::find($id);
        return $controltinsion->delete();
    }
   
    public function destroyCepaMedio($id, $idmedio, $laboratorio)
    {
        // TRAE LOS SEGUIMIENTOS DE LAS CEPAS Y LOS MEDIOS
        $medio = CompraLote::find($idmedio);
        $cepas = $medio->comentariosLoteMedio()->where("lote_cepa_id", $id)->where('lote_laboratorio_id', $laboratorio)->get();
        foreach ($cepas as $cepa) {
            if ($cepa->comentariosLoteMedio->count() > 0 && $cepa->lote_laboratorio_id == $laboratorio) {
                // ELIMINA LOS COMENTARIOS DE LAS CEPAS EN EL MEDIO Y EL ARCHIVO
                foreach ($cepa->comentariosLoteMedio()->where("lote_laboratorio_id", $laboratorio)->get() as $comentario) {
                    $archivo = new Subir(null);
                    $archivo->eliminarArchivo($comentario->foto_url);
                    $comentario->delete();
                }
            }
            $cepa->delete();
        }
        return true;
    }

    public function destroyControlTincion($id, $idtincion, $laboratorio)
    {
        // SE OBTIENE LA TINCIÓN EN LA COMPRA LOTE
        $tincion = CompraLote::find($idtincion);
        // SE OBTIENE LAS CEPAS DEL LOTE DE TINCIÓN
        $cepas = $tincion->comentariosLoteTinciones()->where("lote_cepa_id", $id)->where('lote_laboratorio_id', $laboratorio)->get();
        foreach ($cepas as $cepa) {
            if ($cepa->comentariosLoteTincion->count() > 0 && $cepa->lote_laboratorio_id == $laboratorio) {
                // ELIMINA LOS COMENTARIOS DE LAS CEPAS EN EL MEDIO Y EL ARCHIVO
                foreach ($cepa->comentariosLoteTincion()->where("lote_laboratorio_id", $laboratorio)->get() as $comentario) {
                    $archivo = new Subir(null);
                    $archivo->eliminarArchivo($comentario->foto_url);
                    $comentario->delete();
                }
            }
            $cepa->delete();
        }
        return true;
    }

    public function destroyControlPrueba($id, $idprueba, $laboratorio)
    {
        // SE OBTIENE LA TINCIÓN EN LA COMPRA LOTE
        $prueba = CompraLote::find($idprueba);
        
        // SE OBTIENE LAS CEPAS DEL LOTE DE TINCIÓN
        $cepas = $prueba->comentariosLotePruebaSensibilidad()->where("lote_cepa_id", $id)->where('lote_laboratorio_id', $laboratorio)->get();
        
        foreach ($cepas as $cepa) {
            if ($cepa->comentariosLoteCepa->count() > 0 && $cepa->lote_laboratorio_id == $laboratorio) {
                // ELIMINA LOS COMENTARIOS DE LAS CEPAS EN EL MEDIO Y EL ARCHIVO
                foreach ($cepa->comentariosLoteCepa()->where("lote_laboratorio_id", $laboratorio)->get() as $comentario) {
                    $archivo = new Subir(null);
                    $archivo->eliminarArchivo($comentario->foto_url);
                    $comentario->delete();
                }
            }
            $cepa->delete();
        }

        return true;
    }
}