<?php $__env->startSection('content-section'); ?>
    <div class="pt-5 py-4 px-5">
        <div class="row">
            
            <div class="col-md-9 col-xl-12">
                <div class="tab-content bg-white">
                    <div class="row m-0 mt-4">
                        <div class="col-lg-12" id="card-update">
                            <div class="card shadow mb-3 mt-3 bg-transparent shadow shadow-sm border">
                                <div class="card-header card-header-per">
                                    <h6 class="m-0 font-weight-bold text-primary">Actualizar Medio de cultivo</h6>
                                </div>
                                <div class="card-body">
                                    <div class=" overflow-auto">
                                        <table class="table table-striped table-sm text-center dinamicTable">
                                            <thead>
                                                <tr>
                                                    <th scope="col">Nombre</th>
                                                    <th scope="col">Caracteristica</th>
                                                    <th scope="col">Acción</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <form action="<?php echo e(route('update.medio', ['id' => $medio->id_medio])); ?>"
                                                    method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('PUT'); ?>
                                                    <tr>
                                                        <td>
                                                            <input type="text" placeholder="Ingrese el nombre"
                                                                id="nombre" class="form-control" name="nombre"
                                                                value="<?php echo e(old('nombre', $medio->nom_medio)); ?>">
                                                        </td>
                                                        <td>
                                                            <textarea name="caracteristica" id="caracteristica" cols="30" rows="2"><?php echo e(old('caracteristica', $medio->caracteristica)); ?></textarea>
                                                        </td>
                                                        <td>
                                                            <button type="submit"
                                                                class="btn btn-primary btn-sm ml-auto">Actualizar</button>
                                                        </td>
                                                    </tr>
                                                </form>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="card shadow mb-3 bg-transparent shadow shadow-sm border">
                                <div class="card-header card-header-per">
                                    <h6 class="m-0 font-weight-bold text-primary">Agregar Lote</h6>
                                </div>
                                <div class="card-body">
                                    <div class=" overflow-auto">
                                        <table class="table table-striped table-sm text-center dinamicTable">
                                            <thead>
                                                <tr>
                                                    <th scope="col">Lote</th>
                                                    <th scope="col">Fecha Compra</th>
                                                    <th scope="col">Fecha Vencimiento</th>
                                                    <th scope="col">Acción</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <form
                                                    action="<?php echo e(route('store.compra.lote', ['itemId' => $medio->id_medio, 'section' => 'Medio'])); ?>"
                                                    method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="id_medio" value="<?php echo e($medio->id_medio); ?>">
                                                    <tr>
                                                        <td>
                                                            <input type="text" placeholder="Ingrese lote"
                                                                class="form-control" name="lote"
                                                                value="<?php echo e(old('lote')); ?>">
                                                        </td>
                                                        <td>
                                                            <input type="date" class="form-control" name="created_at"
                                                                value="<?php echo e(old('created_at')); ?>" required>
                                                        </td>
                                                        <td>
                                                            <input type="date" class="form-control"
                                                                name="fecha_vencimiento"
                                                                value="<?php echo e(old('fecha_vencimiento')); ?>">
                                                        </td>
                                                        <td>
                                                            <button type="submit"
                                                                class="btn btn-primary btn-sm ml-auto">Agregar</button>
                                                        </td>
                                                    </tr>
                                                </form>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="col-lg-12">
                            <div class="card shadow mb-3 bg-transparent shadow shadow-sm border">
                                <div class="card-header card-header-per">
                                    <h6 class="m-0 font-weight-bold text-primary">Lotes Agregados</h6>
                                </div>
                                <div class="card-body">
                                    <div class=" overflow-auto">
                                        <table class="table table-striped table-sm text-center dinamicTable">
                                            <thead>
                                                <tr>
                                                    <th scope="col">Lote</th>
                                                    <th scope="col">Fecha Compra</th>
                                                    <th scope="col">Fecha Vencimiento</th>
                                                    <th scope="col">Estado</th>
                                                    <th scope="col" colspan="2">Acción</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if(isset($medio->comprasLote)): ?>
                                                    <?php $__currentLoopData = $medio->comprasLote; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <form
                                                                action="<?php echo e(route('update.compra.lote', ['id' => $compra->id, 'section' => 'Medio'])); ?>"
                                                                method="POST">
                                                                <?php echo method_field('PUT'); ?>
                                                                <?php echo csrf_field(); ?>
                                                                <td>
                                                                    <input type="text" placeholder="Ingrese lote"
                                                                        class="form-control" name="lote"
                                                                        value="<?php echo e(old('lote', $compra->lote)); ?>">
                                                                </td>
                                                                <td>
                                                                    <input type="date" class="form-control"
                                                                        name="created_at"
                                                                        value="<?php echo e(old('created_at', is_null($compra->created_at) ? null : $compra->created_at->toDateString())); ?>">
                                                                </td>
                                                                <td>
                                                                    <input type="date" class="form-control"
                                                                        name="fecha_vencimiento"
                                                                        value="<?php echo e(old('fecha_vencimiento', $compra->fecha_vencimiento)); ?>">
                                                                </td>
                                                                <td>
                                                                    <select name="estado" class="form-control">
                                                                        <?php if($compra->estado == 1): ?>
                                                                            <option value="1" selected>Activo</option>
                                                                            <option value="0">Inactivo</option>
                                                                        <?php else: ?>
                                                                            <option value="1">Activo</option>
                                                                            <option value="0" selected>Inactivo
                                                                            </option>
                                                                        <?php endif; ?>
                                                                    </select>
                                                                </td>
                                                                <td>
                                                                    <button
                                                                        class="btn btn-success btn-sm">Actualizar</button>
                                                                </td>
                                                            </form>
                                                            <td>
                                                                <form
                                                                    action="<?php echo e(route('destroy.compra.lote', ['id' => $compra->id, 'section' => 'Medio'])); ?>"
                                                                    class="form-eliminar" method="POST">
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php echo method_field('DELETE'); ?>
                                                                    <button class="btn btn-danger btn-sm">Eliminar</button>
                                                                </form>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
            
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app-v2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aaitytnh/public_html/apitool-labmarthaperdomo.quik-sftw.com.co/resources/views/medio/medioEdit.blade.php ENDPATH**/ ?>