<?php $__env->startSection('content-section'); ?>
    <div class="py-3 px-2 <?php echo e($nomSection); ?>">
        <div class="inputs-hidden">
            <input type="hidden" id='resultado_analito_node'>
            <input type="hidden" id='resultado_analito' value="<?php echo e($id_analito_lab); ?>">
            <input type="hidden" id='resultado_fecha_inicial' value="<?php echo e($fecha_inicial); ?>">
            <input type="hidden" id='resultado_fecha_final' value="<?php echo e($fecha_final); ?>">
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3>Agregar Medio de cultivo</h3>
                        <p>Relacione el lote de un medio de cultivo a un laboratorio existente.</p>
                    </div>
                    <div class="card-body">
                    <form action="<?php echo e(route('store.medio.lote.lab')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-12 mb-3">
                                    <div class="row align-items-end">
                                        <div class="col-12 col-md-12 mb-2 mb-sm-0">
                                            <label for="loteMedioId">Medio Cultivo</label>
                                            <select class="form-control" name="loteMedioId" id="loteMedioId">
                                                <?php $__currentLoopData = $lotesMedio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php $__currentLoopData = $lote->medios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $medio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($lote->id); ?>">Lote: <?php echo e($lote->lote); ?> |
                                                            Medio:
                                                            <?php echo e($medio->nom_medio); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-12 col-md-12 mb-2 mb-sm-0 mt-2">
                                            <label for="laboratorioId">Laboratorio</label>
                                            <select class="form-control" name="laboratorioId" id="laboratorioId">
                                                <?php $__currentLoopData = $laboratorios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $laboratorio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($laboratorio->id_laboratorio); ?>">
                                                        <?php echo e($laboratorio->nom_laboratorio); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-4 col-md-12 mb-2 mb-sm-0  mt-2">
                                            <button class="btn btn-primary w-100" id="addRowButton">Agregar</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    </form>
                </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3>Listado de Laboratorios</h3>
                        <p>Encuentre los lotes de medios de cultivos relacionados a cada laboratorio.</p>
                    </div>
                    <div class="card-body">
                        <div id="tree">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $(function() {
            $("#tree").fancytree({
                onActivate: function(node) {
                    alert("You activated " + node.data.title);
                },
                source: <?php echo json_encode($arbol, 15, 512) ?>,
                click: function(event, data) {
                    console.log(data.node.data);
                    if(data.node.data.id !== undefined && data.node.data.laboratorioId !== undefined && data.node.children.length === 0){
                        window.location.href = '/microbiologia/detalleMedio/' + data.node.data.id + '/lab/' + data.node.data.laboratorioId;
                    }
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app-v2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aaitytnh/public_html/apitool-labmarthaperdomo.quik-sftw.com.co/resources/views/microbiologia/mediosDeCultivos/index.blade.php ENDPATH**/ ?>