<?php

namespace App\Http\Controllers;

// Controladores
use App\Http\Controllers\Controller;
use App\CompraLote;

// Modelos
use App\Laboratorio;
use Illuminate\Support\Facades\DB;
use App\Tincion;

// Requests
use App\Resource\MedicionTincion\ListarTiposMedicionesTincion;
use App\Resource\Cepa\Manager as CepaManager;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Requests\TincionRequest;
use App\Resource\CompraLote\Manager;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use App\LoteLaboratorio;
use Carbon\Carbon;
use Exception;


class TincionController extends Controller
{
    protected $tableTinciones;
    protected $array_get;

    public function __construct()
    {
        $this->tableTinciones = new Tincion();
        $this->array_get = array();
    }

    public static function listTinciones()
    {
        $tincion = new Tincion();
        return $tincion
            ->orderBy("tincion.nom_tincion", "asc")
            ->get();
    }
    public function section()
    {
        $tinciones = $this->tableTinciones
            ->orderByRaw('CAST(estado AS UNSIGNED) DESC') // Convierte 'estado'
            ->orderBy('nom_tincion', 'asc') // Sin prefijos de tabla
            ->get();

        return view("tincion.tincionSection")
            ->with("tinciones", $tinciones)
            ->with("nomSection", "SeeSectionTinciones");
    }
    public function index()
    {
        $tinciones = $this->tableTinciones
            ->orderByRaw('CAST(estado AS UNSIGNED) DESC') // Convierte 'estado' explícitamente
            ->orderBy('nom_tincion', 'asc') // No uses el prefijo de tabla
            ->get();

        return view("tincion.tincionIndex")
            ->with("tinciones", $tinciones);
    }
    public function store(TincionRequest $req)
    {
        $this->tableTinciones->nom_tincion = $req->nombre;
        $this->tableTinciones->save();
    }
    public static function list()
    {
        $tableTinciones = new Tincion();
        return $tableTinciones
            ->where("estado", 1)
            ->orderBy("nom_tincion", "asc")
            ->get();
    }
    public static function listAll()
    {
        $tableTinciones = new Tincion();
        return $tableTinciones
            ->orderByRaw('CAST(estado AS UNSIGNED) DESC') // Convierte 'estado'
            ->orderBy("nom_tincion", "asc")
            ->get();
    }
    public function listHTML()
    {
        $tinciones = $this->tableTinciones
            ->where("estado", 1)
            ->orderBy("nom_tincion", "asc")
            ->get();

        return view("tincion.tincionList")
            ->with("tinciones", $tinciones);
    }
    public function destroy(Request $req)
    {
        $this->tableTinciones
            ->where("id_tincion", $req->id)
            ->delete();
    }
    public function status(Request $req)
    {
        $statusNow = $this->tableTinciones
            ->where("id_tincion", $req->id)
            ->first()
            ->estado;

        $registroUpdate = $this->tableTinciones
            ->where("id_tincion", $req->id);

        if ($statusNow == 1) {
            $registroUpdate->update(["estado" => 0]);
        } else {
            $registroUpdate->update(["estado" => 1]);
        }
    }
    public function edit($id)
    {

        $tincion = $this->tableTinciones
            ->where("id_tincion", $id)
            ->with('comprasLote')
            ->first();

        return view("tincion.tincionEdit")
            ->with("tincion", $tincion);
    }
    public function show(Request $req)
    {
        $tincion = $this->tableTinciones
            ->where("id_tincion", $req->id)
            ->first();

        return view("tincion.tincionShow")
            ->with("tinciones", $tincion)
            ->with("campo", $req->campo);
    }
    public function update(TincionRequest $req)
    {
        $tincion = $this->tableTinciones
            ->where("id_tincion", $req->id)
            ->first();

        $tincion->update(
            [
                "nom_tincion" => $req->nombre
            ]
        );
        return redirect()->back();
    }
    public function asignarloteLaboratorio(Request $request)
    {
        $validatedData = $request->validate([
            'loteTincionId' => 'required|exists:compras_lotes,id',
            'laboratorioId' => 'required|exists:laboratorio,id_laboratorio',
        ]);

        // dd($request->all());
        DB::beginTransaction();
        LoteLaboratorio::create([
            'lote_id' => $validatedData['loteTincionId'],
            'id_laboratorio' => $validatedData['laboratorioId']
        ]);
        DB::commit();
        return redirect()->back();
    }

    public function detalles($id, $labId)
    {
        $laboratorio = Laboratorio::find($labId);
        return view('microbiologia.tinciones.show')
            ->with('data', $laboratorio)
            ->with('tincion', $laboratorio->loteLaboratorio()->where('lote_id', $id)->first())
            ->with('data', $laboratorio)
            ->with('lotesCepa', Manager::listarComprasLoteCepa())
            ->with('hoy', Carbon::now())
            ->with('tiposMedicion', ListarTiposMedicionesTincion::listadoMedicion());
    }

    public function eliminarTincionLaboratorio(Request $request, $id)
    {

        $laboratorio = Laboratorio::find($request->laboratorioId);
        $lote = $laboratorio->loteLaboratorio()->where('lote_id', $id)->first();
        $manager = new CepaManager();

        foreach ($lote->lote->LoteTincionCepas as $medio) {
            $manager->destroyControlTincion($medio->lote_cepa_id, $lote->lote->id);
        }

        $lote->delete();
        Alert::success('Se ha eliminado la tinción del laboratorio');
        return redirect()->route('microbiologia.tinciones');
    }
}
