@extends('layouts.PDF.app')
@section('certificado')
    <p class="text-left subtitulo">11 de febrero de 2025<br>
        Laboratorio Clínico XXXX<br>
        Control de Calidad de Microbiología<br>
        Control de calidad de Medios de cultivo</p>
@endsection
@section('titulo')
    <h1 class="text-center">CONTROL DE CALIDAD DE ANTIBIÓTICOS</h1>
@endsection
@section('content')
<div class="info-section">
    <h2 class="text-center">ANTIBIÓTICOS</h2>
    <table class="tabla-principal">
       
            <tr>
                <td><strong>Fecha informe</strong></td>
                <td>{{ $fechaActual }}</td>
                <td><strong>Antibiotico</strong></td>
                <td>{{ $Antibiotico }}</td>
            </tr>
            <tr>
                <td><strong>Lote</strong></td>
                <td>{{$loteAntibiotico}}</td>
                <td><strong>Fecha de expiración</strong></td>
                <td>{{$VencimientoLoteAntibiotico}}</td>
            </tr>
    </table>
</div>
    <div class="cepas-section">
        <h2 class="text-center">CEPAS DE CONTROL</h2>
        <table class="tabla-principal">
            <thead>
                <tr>
                    <td class="text-center"><strong>Cepa</strong></td>
                    <td class="text-center"><strong>Lote</strong></td>
                    <td class="text-center"><strong>F. vencimiento</strong></td>
                </tr>
            </thead>
            @foreach ($AntibioticosDeLote as $key => $cepas)
                <tr>
                    <td class="text-center"><i>{{ $cepas->loteCepas->cepas->first()->nom_cepa }}</i></td>
                    <td class="text-center">{{ $cepas->loteCepas->lote }}</td>
                    <td class="text-center">{{ $cepas->loteCepas->fecha_vencimiento }}</td>
                </tr>
            @endforeach
        </table>
    </div>
    <!-- Controles de Cepas -->
    <div class="controles-section">
        <table class="tabla-principal">
            <thead>
                <tr>
                    @foreach ($ControlesAntibiotico as $ke1 => $cepas)
                        <th><i>{{ $cepas->loteCepas->cepas->first()->nom_cepa }}</i></th>
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @for ($i = 0; $i < $maxRegistros; $i++)
                    <tr>
                        @foreach ($ControlesAntibiotico as $cepas)
                            <td>
                                @if (isset($cepas->comentariosLoteCepa[$i]))
                                    <div>
                                        @if (!is_null($cepas->comentariosLoteCepa[$i]->url()))
                                            <img src="{{ $cepas->comentariosLoteCepa[$i]->url() }}"
                                                alt="Imagen no disponible" class="imagen-control">
                                        @else
                                            <p class="sin-imagen">No se ha súbido imagen</p>
                                        @endif
                                        <div class="contenido-texto">
                                            <p>
                                                <small><i>Fecha de registro
                                                        {{ $cepas->comentariosLoteCepa[$i]->created_at->toDateString() }}</i></small><br>
                                                <strong>Usuario:</strong>{{ Auth::user()->nom_usuario ?? 'SW' }}<br>
                                                <strong>Comentario:</strong>
                                                {{ $cepas->comentariosLoteCepa[$i]->comentario }}<br>
                                                <strong>Resultado:</strong>
                                                {{ $cepas->comentariosLoteCepa[$i]->tipoMedicion->nombre }}
                                            </p>
                                        </div>
                                    </div>
                                @endif
                            </td>
                        @endforeach
                    </tr>
                @endfor
            </tbody>
        </table>
    </div>
@endsection
