@extends('layouts.PDF.app')
@section('certificado')
    <p class="text-left subtitulo">11 de febrero de 2025<br>
        Laboratorio Clínico XXXX<br>
        Control de Calidad de Microbiología<br>
        Control de calidad de Medios de cultivo</p>
@endsection
@section('titulo')
    <h1 class="text-center">CONTROL DE CALIDAD DE TINCIONES</h1>
@endsection
@section('content')
    <div class="info-section">
        <h2 class="text-center">Tinción</h2>
        <table class="tabla-principal">
           
                <tr>
                    <td><strong>Fecha informe</strong></td>
                    <td>{{ $fechaActual }}</td>
                    <td><strong>Tinción</strong></td>
                    <td>{{ $nombreTincion }}</td>
                </tr>
                <tr>
                    <td><strong>Lote</strong></td>
                    <td>{{$loteTincion}}</td>
                    <td><strong>Fecha de expiración</strong></td>
                    <td>{{$VencimientoLoteTincion}}</td>
                </tr>
        </table>
    </div>
    <div class="cepas-section">
        <h2 class="text-center">Microorganismos de control</h2>
        <table class="tabla-principal">
            <thead>
                <tr>
                    <td class="text-center"><strong>Cepa</strong></td>
                    <td class="text-center"><strong>Lote</strong></td>
                    <td class="text-center"><strong>F. vencimiento</strong></td>
                </tr>
            </thead>
            @foreach ($CepasDeLote as $key => $cepas)
                <tr>
                    <td>{{ $cepas->loteCepas->cepas->first()->nom_cepa }}</td>
                    <td class="text-center">{{ $cepas->loteCepas->lote }}</td>
                    <td class="text-center">{{ $cepas->loteCepas->fecha_vencimiento }}</td>
                </tr>
            @endforeach
        </table>
    </div>
    <div class="controles-section">
        <table class="tabla-principal">
            <thead>
                <tr>
                    @foreach ($ControlesCepa as $ke1 => $cepas)
                        <th><i>{{ $cepas->loteCepas->cepas->first()->nom_cepa }}</i></th>
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @for ($i = 0; $i < $maxRegistros; $i++)
                    <tr>
                        @foreach ($ControlesCepa as $cepas)
                            <td>
                                @if (isset($cepas->comentariosLoteCepaTincion[$i]))
                                    <div>
                                        @if ($cepas->comentariosLoteCepaTincion[$i]->foto_url)
                                            <img src="{{ public_path('storage/' . $cepas->comentariosLoteCepaTincion[$i]->foto_url) }}"
                                                alt="Imagen no disponible" class="imagen-control">
                                        @else
                                            <p class="sin-imagen">No se ha súbido imagen</p>
                                        @endif
                                        <div class="contenido-texto">
                                            <p>
                                                <small><i>Fecha de registro
                                                        {{ $cepas->comentariosLoteCepaTincion[$i]->created_at->toDateString() }}</i></small><br>
                                                <strong>Usuario:</strong>{{ Auth::user()->nom_usuario ?? 'SW' }}<br>
                                                <strong>Comentario:</strong>{{ $cepas->comentariosLoteCepaTincion[$i]->comentario }}<br>
                                                <strong>Resultado:</strong>{{ $cepas->comentariosLoteCepaTincion[$i]->tipoMedicion->nombre }}
                                            </p>
                                        </div>
                                    </div>
                                @endif
                            </td>
                        @endforeach
                    </tr>
                @endfor
            </tbody>
        </table>
    </div>
@endsection
