<!doctype html>
<html lang="es">
<head>
    <link rel="shortcut icon" type="image/jpg" href="img/faviconAPIT_v1.jpg">
    
    <link type="text/css" href="<?php echo e(public_path('/css/bootstrap.min.css?v_beta')); ?>" rel="stylesheet">
    
    
    
    
    
    
    <style>
        .header_table {
            min-height: 40px;
        }

        .header_table_main {
            min-height: 60px;
            display: block;
            margin-bottom: 30px;
        }

        .border-left {
            border-left: 2px solid #000;
        }

        .border-header-bar {
            margin-top: 0.3rem;
            border-bottom: 2px solid #1C50A4;
        }

        .small {
            font-size: 0.8rem;
        }

        .header-fixed {
            position: fixed;
            height: 5.4rem;
            min-height: 5.4rem;
            top: -7rem;
            right: 0;
            left: 0;
        }

        .ml-auto {
            margin-left: auto;
        }

        .img-quik {
            width: 7rem;
        }

        .img-api-tools {
            width: 10rem;
        }

        .color-font {
            color: #1C50A4 !important;
        }

        @page  {
            margin: 7rem 0 0 0;
        }
    </style>
    <title>Reporte de Auditoría</title>
</head>
<body>
<header class="header-fixed  border-header-bar pt-3 px-4">
    <table class="pb-4  mx-4">
        <tbody>
        <tr>
            <td class="pr-4">
                <img class="img-api-tools" src="img/banner-APITool.jpg" alt="logoAPIT">
            </td>
            <td class="border-left pl-4 pr-4 mr-4">
                <h1 class="color-font  font-weight-bold text-primary h6 mb-0">Informe de Auditoría</h1>
                <p class="mb-0 small">Laboratorio: <?php echo e($laboratorio); ?></p>
                <p class="mb-0 small"><span>Fecha inicial: <?php echo e($fecha_inicial); ?>   </span>
                    <span>   Fecha final: <?php echo e($fecha_final); ?></span></p>
                <p class="mb-0 small">Fecha de expedición: <?php echo e(date('Y/m/d h:i:s a')); ?></p>
            </td>
            <td class="pl-4 ml-auto">
                <img class="img-quik pl-4 ml-4 ml-auto" src="img/logo-quik.png" alt="logo-quik">
            </td>
        </tr>
        </tbody>
    </table>
</header>
<main class="header-margin px-4 mx-4 pb-4 mb-4">
    <div class="">
        <div class="">
            <div class="shadow w-100">
                <div class="card-header border-bottom header_table_main mb-3">
                    <h6 class="color-font  font-weight-bold text-primary h4 p-0 m-0 header_table_main">Listado de actividades</h6>
                </div>
                <div class="p-0 card-body text-center pt-0 mt-2">
                    <div class="Cont_Table_Auditoria overflow-auto">
                        <table class="table table-striped table-sm text-center dinamicTable SeeIndexAuditoria">
                            <thead>
                            <tr class="header_table">
                                <th scope="col">N°</th>
                                <th scope="col">Laboratorio</th>
                                <th scope="col">Usuario</th>
                                <th scope="col">Fecha</th>
                                <th scope="col">Acción</th>
                                <th scope="col">Descripción</th>
                            </tr>
                            </thead>
                            <tbody>

                            <?php $__currentLoopData = $historicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $historico): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style='width:5%'><?php echo e($index+1); ?></td>
                                    <td style='width:15%'><?php echo e($historico->num_laboratorio); ?></td>
                                    <td style='width:10%'><?php echo e($historico->usuario); ?></td>
                                    <td style='width:10%'><?php echo e(date_format(date_create($historico->fecha), "F d, Y H:i:s")); ?></td>
                                    <td style='width:10%'><?php echo e($historico->nom_titulo); ?></td>
                                    <td style='width:50%'>
                                        <div class='textarea-log' readonly='true'><?php echo e($historico->descripcion); ?></div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
</body>
</html>
<?php /**PATH C:\wtredataphp\apitool-test3.quik-apps.com.co\resources\views/auditoria/auditoriaPDFTemplate.blade.php ENDPATH**/ ?>